% ALPHA ENGINE DEFINITION
% Generated 26-Nov-2019 14:03:35

% SUGGESTED CITATION:
% 2015 Ford 2.7L EcoBoost V6 Engine Tier 3 Fuel - ALPHA Map Package. Version 2019-11. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2019.


% Constructor
engine = class_REVS_engine();
engine.name =  '2015 Ford 2.7L EcoBoost V6 Engine Tier 3 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.694; 
engine.num_cylinders =  6; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  10; 
engine.bore_mm =  83; 
engine.stroke_mm =  83; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     105.03391438501875	;     157.18435243460931	;     183.36429121452426	;     209.54422999443918	;     235.72416877435413	;     315.54389323222813	;     367.31035884637993	;     420.10075095503510	;     473.46419283476172	;     525.51863777549261	;     575.68638179481752	;     604.47070088455837	;     633.25501997429933		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     232.08000000000001	;     363.56999999999999	;     421.47000000000003	;     457.49000000000001	;     454.13000000000000	;     479.25499999999988	;     461.78888888888895	;     455.93333333333328	;     433.23000000000002	;     418.07083333333327	;     382.85000000000002	;     328.15714285714290	;    0.00000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	    0.00000000000000000	;     157.19744240399928	;     209.55170997694773	;     261.90410755426905	;     366.68967613113944	;     471.48192756884436	;     525.30807553883392	;     633.25501997429933		]; 
engine.naturally_aspirated_torque_Nm = [	     180.81847488547547	;     171.09394843590599	;     162.67011541367296	;     174.15161620570851	;     181.38153555259967	;     214.54295007430514	;     209.89137951473592	;     166.71947068814549		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     131.00441365469436	;     288.08404633418399	;     314.26398511409894	;     471.34361779358858	;     633.25501997429933		]; 
engine.closed_throttle_torque_Nm = [	    -9.8423753846153854	;    -10.720000000000001	;    -20.280000000000001	;    -27.460000000000001	;    -13.000000000000000	;    -14.084676676923078		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     31.459559767197788	;     62.919119534395577	;     104.87159876458327	;     131.00441365469436	;     157.19744240399928	;     183.37045120011953	;     209.55170997694773	;     235.73032875994937	;     261.90410755426905	;     288.08712632698155	;     314.31052722748552	;     366.68967613113944	;     419.09090531649349	;     471.48192756884436	;     498.39500155383917	;     525.30807553883392	;     575.92736789795401	;     604.59119393612673	;     633.25501997429933		]; 
engine.fuel_map_torque_Nm = [	    -28.833000000000002	;    -12.955833333333334	;     6.3006018518518516	;     25.557037037037038	;     46.987154882154876	;     68.417272727272717	;     96.838750000000005	;     105.69100000000000	;     118.74500000000000	;     148.19499999999999	;     181.41750000000002	;     203.42916666666667	;     228.28970588235293	;     254.16499999999999	;     283.63850000000002	;     301.06270588235293	;     318.48691176470584	;     340.56046296296290	;     368.60109907120739	;     395.56000000000000	;     410.11434228650137	;     439.20826719576723	;     457.02361111111111	;     479.25499999999988	;     503.21774999999991		]; 
engine.fuel_map_gps = [
   0.12960299435860118	   0.18578887157746796	   0.23766523881917367	   0.29476071033436235	   0.32429986799551874	   0.35349088842988724	   0.38715058846399419	   0.42133399536505695	   0.45136444026731348	   0.49030472282356458	   0.54911494576774289	   0.61529473557432124	   0.76735621774867513	   0.91958653153100034	    1.0225394790806557	   0.99695861425011723	   0.97419778485681396	   0.95791618192981665	   0.95519507748192289	   0.95370723361928988	;
   0.10234046853934604	   0.16944031654390440	   0.23452459495430372	   0.30212132876504988	   0.34037775592539116	   0.37216534167205478	   0.41629905355519159	   0.46564242957426544	   0.50937451202464079	   0.55600924687884212	   0.60618164371625338	   0.65090411422959815	   0.80652410057556967	   0.99750369081221302	    1.1999401121908029	    1.2900231025712552	    1.3586413740746850	    1.4426054397857055	    1.4843938247808628	    1.5255516320239848	;
  0.072092100944542270	   0.14832922389961847	   0.22895608819555846	   0.30696810211876441	   0.35749879743237384	   0.40692379536670847	   0.45961864228099109	   0.51929071841755692	   0.59408978183445760	   0.66778625101034239	   0.72608309654783831	   0.81571713397590084	    1.0138515488097439	    1.2196954629067864	    1.5262416225736044	    1.6881613672246727	    1.8323491702799899	    2.0299220242710514	    2.1253432090433373	    2.2179367995671040	;
  0.051253094327114973	   0.13003875255428538	   0.20584690567712793	   0.32701699819301699	   0.41144554579248405	   0.49075820795896979	   0.58104329486567596	   0.67529615536226673	   0.78235399275728768	   0.88403634509125906	    1.0050050299099211	    1.1637707488178450	    1.4071485231076355	    1.6170383674573809	    1.9683823440847930	    2.1554334197320997	    2.3348906241937506	    2.6211030166233313	    2.7663617939260061	    2.9080835682245878	;
  0.042038316994002671	   0.14822129295582592	   0.25589235417747308	   0.43180843739588526	   0.56404715129595118	   0.68988315746167928	   0.82177202257947068	   0.93548172470202573	    1.0556219571071717	    1.1860379603908677	    1.3409319401832318	    1.5091902573281655	    1.8242991645584112	    2.1443616690691631	    2.5433904085535026	    2.7422709586176439	    2.9383846906557212	    3.2932873681375536	    3.4862917416994974	    3.6771739482467782	;
  0.055511400176665032	   0.20939400288315480	   0.37011269343212622	   0.58243099599780934	   0.73352042405531903	   0.87621609690987712	    1.0085205281026037	    1.1534068513559332	    1.3241320746994445	    1.4910634735091268	    1.6688683115230338	    1.8734512518166682	    2.2611205186418304	    2.6927704701348163	    3.1562796481431268	    3.3659245189505227	    3.5776667782960678	    3.9903864066566492	    4.2251179749293772	    4.4596331306729198	;
   0.12306437724176281	   0.32064077132721891	   0.51785294016285943	   0.76722609401994513	   0.94478532934323545	    1.1192399599908522	    1.3012763614527671	    1.5002798671595803	    1.7077120941877502	    1.9236179062169720	    2.1479506991623003	    2.3936228357451625	    2.8766094705928871	    3.3956706966765524	    3.9303518036068530	    4.1962820852236700	    4.4615752940295046	    4.9684703463015616	    5.2594333844842955	    5.5513374282541772	;
   0.15069071966984551	   0.35874356528816992	   0.56526252244659592	   0.83401362134892421	    1.0214407605303550	    1.2114002949832003	    1.4084874095840225	    1.6199938691948133	    1.8384134953154767	    2.0671496428386145	    2.3078149073363057	    2.5643836375363458	    3.0732810975979410	    3.6143744509725284	    4.1727914052879118	    4.4563368744582688	    4.7404416977912742	    5.2831796131889002	    5.5949619377821502	    5.9078772298667923	;
   0.19449199970968081	   0.41707056871130166	   0.63808937576599201	   0.93728157946604018	    1.1393321734035076	    1.3520012929914502	    1.5688235047526218	    1.7986339515683154	    2.0341445195510324	    2.2813665852533500	    2.5441291938870521	    2.8169200726850714	    3.3645302685382648	    3.9374517348085929	    4.5307245394414544	    4.8408214175822017	    5.1535651765394750	    5.7526386512504883	    6.0971580764433337	    6.4430589609130982	;
   0.31749397449923655	   0.57228947910198313	   0.82984633120666429	    1.1818485607865423	    1.4005346617231174	    1.6580404817249679	    1.9146683698948168	    2.1895645647621618	    2.4675433790174393	    2.7568327605535989	    3.0619715577059701	    3.3792512425536865	    4.0239378122400549	    4.6785270615025167	    5.3459569726799883	    5.7211126656360962	    6.1064600474119484	    6.8622157881971715	    7.3003697331847306	    7.7408668204264046	;
   0.51588195315697605	   0.79852027368657397	    1.0870141119451342	    1.5013871739436675	    1.7958674789276265	    2.0593537655530190	    2.3271402073861682	    2.6148487848443160	    2.9185525878932244	    3.2432670115222164	    3.5974618719203604	    3.9704172771420252	    4.7355018753002280	    5.5051392784165678	    6.3033078834835798	    6.7710807389854386	    7.2641835123591774	    8.2746302826816613	    8.8705902421046314	    9.4715787166288266	;
   0.66752135084553732	   0.97391526783861215	    1.2859081959852878	    1.7297100715103113	    2.0275496402613404	    2.3145555251695566	    2.6056327826276311	    2.9142407964868151	    3.2429667030107279	    3.5904433934760096	    3.9689322449495990	    4.3630164691810709	    5.1799735029706993	    5.9850705276184657	    6.9310079692805546	    7.4931558939828316	    8.0894036071174327	    9.3177937072842631	    10.040433718977830	    10.768398183680118	;
   0.83736918614831202	    1.1826915483491358	    1.5267242745624379	    1.9967779476826824	    2.3380034926406763	    2.6073942564005490	    2.9170090094090435	    3.2664394712755240	    3.6404392142785387	    4.0285730683628813	    4.4257906239955354	    4.8277044346804745	    5.6451242522372160	    6.5225082215033412	    7.6391973959275674	    8.3394476292515911	    9.0840284711121040	    10.596270094729174	    11.470567308445439	    12.346929458742492	;
   0.97178728724956343	    1.3874344256825284	    1.8007256723167788	    2.3390639038926073	    2.6588690622534448	    2.9520167848917103	    3.2895188968870399	    3.6707375596638645	    4.0840979464019895	    4.5050046830711201	    4.9295194743698856	    5.3555222126161031	    6.2348639166046960	    7.1610051648724546	    8.4311840700728524	    9.3009924689703318	    10.225488626555931	    12.059121729668735	    13.082228961300986	    14.095253571251428	;
    1.0153568624793528	    1.5319745239505043	    2.0475805323531580	    2.7178502049164992	    3.0937750532251549	    3.4199313658835093	    3.7503047320748437	    4.1349285064177961	    4.5760614906991162	    5.0217154413112146	    5.4841467866838345	    5.9768647679540674	    6.9710301583682828	    8.1089793475967316	    9.5727300458473348	    10.579337139389164	    11.677247763114378	    13.877736485896886	    15.040454491296813	    16.170133907373049	;
   0.97403576542443171	    1.5497226152307100	    2.1228691025882824	    2.8665301787405375	    3.2918765475182830	    3.6693512730519311	    4.0396630727682776	    4.4393215077509263	    4.8746729553179824	    5.3523903057730102	    5.8752550026390677	    6.4068158372658353	    7.4699611793414702	    8.7528560448719102	    10.327712132896773	    11.393498410160836	    12.552428390121049	    14.950632456406526	    16.193915702919107	    17.432083876965244	;
   0.88960285619415869	    1.5250712849851087	    2.1555963235033713	    2.9694424991926280	    3.4442363527843902	    3.8988317802514421	    4.3429188762289783	    4.7822488138689323	    5.2208157983564965	    5.7255904746329387	    6.3485516460456148	    6.8977725636527483	    8.0346039672543679	    9.4687753074152194	    11.197669774111079	    12.270060427322417	    13.398890648859949	    15.945830631850571	    17.305864585017122	    18.744115159957943	;
   0.70523490382829535	    1.4232161603140874	    2.1343199606676091	    3.0543743701805246	    3.6088003391905961	    4.1618009824298623	    4.7284094261520027	    5.3146644025079421	    5.8161943227118416	    6.3999905535756820	    7.0898051565628935	    7.5481984948459715	    8.8281173604377816	    10.466638355236743	    12.729221225642508	    13.554432964517664	    14.399378460569016	    16.764001793061553	    18.658205700923268	    20.545221723420269	;
   0.30727253257582754	    1.1585843836523699	    2.0059538443782077	    3.1205034860656125	    3.8035922493665484	    4.4843081374845823	    5.1717111818901387	    5.9297239699126907	    6.5833767677413091	    7.1925610206974424	    7.8571374827615665	    8.5964379693454145	    10.016451563974412	    11.734167309734087	    14.581985205353684	    15.323992922642384	    16.106753783610767	    19.186522902559556	    21.069068424829769	    22.960806002761338	;
   0.00000000000000000	   0.81513257464348265	    1.7813845521090175	    3.1308765235505378	    3.9699988909847828	    4.8053469074034885	    5.6246127962547892	    6.4289579003379869	    7.1822135408892152	    7.9635294784277031	    8.7139820316586807	    9.6862195578225023	    11.106615289294625	    12.591164940139254	    15.715996567910658	    16.944975395542173	    18.237156135846561	    21.891327259520807	    23.560259304375595	    25.241847723792944	;
   0.00000000000000000	   0.76291473409776023	    1.7017163677734655	    3.1095168669433240	    4.0314858482131424	    4.9554647394884999	    5.8671956570487742	    6.7192042078739771	    7.6126808415998601	    8.4818422637660404	    9.3477930957607835	    10.330476937113360	    11.746119453162505	    13.265330770859487	    16.366567290463991	    17.767036078030817	    19.261907461973141	    22.870644021256087	    24.661845512681271	    26.389058410906507	;
   0.00000000000000000	   0.63755394625497808	    1.6791878427402231	    3.0665355272650845	    4.0798301418083049	    5.1434103427626026	    6.1891819544611808	    7.2013774368402563	    8.3070071922176894	    9.3959459291515426	    10.372480114536847	    11.455761486750923	    13.321465190708766	    15.194164315102379	    17.606986469138871	    19.234770036227527	    20.958225344349803	    24.485380294430406	    26.447835587077069	    28.385105844877309	;
   0.00000000000000000	   0.54892234846614241	    1.6531657130660795	    3.1249309995696430	    4.0838838678255982	    5.2459999957832020	    6.3886271690715795	    7.5371146008601047	    8.8041127114414284	    10.142569394493497	    11.411044361602828	    12.593926037386090	    14.242508160655639	    15.976764820970969	    18.616868399737331	    20.246236344000504	    21.969459326303916	    25.437247665113627	    27.430501709271972	    29.423619860300498	;
   0.00000000000000000	   0.42998411656855207	    1.6111884603937356	    3.1896622184456116	    4.1757205211878468	    5.4242898704456346	    6.7853086809651559	    8.1981567314196475	    9.6884502991838914	    11.241247381920545	    12.800434898255116	    14.268590296592524	    15.724066233324534	    17.400589757339290	    19.999894063744673	    21.572041919620712	    23.234869312116050	    26.620149900351937	    28.606587066302612	    30.607385181146750	;
   0.00000000000000000	   0.29576016206254946	    1.5586722013597920	    3.2552804393903507	    4.3295421674866077	    5.6826867596832047	    7.3198709997118776	    9.0176083649358674	    10.748207842059934	    12.460358298190373	    14.079736628249201	    15.524482637252303	    17.461671967712487	    19.161724766528099	    21.562465675096135	    23.036655720396890	    24.611920504084850	    27.895450925683988	    29.848213274233398	    31.821167326566947	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 25402');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000		]; 
engine.idle_speed_radps.table = [	     73.303828583761842	;     73.303828583761842		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
engine.DFCO_min_duration_secs =  2; 
engine.DFCO_refuel_multiplier_time_secs = [	    0.00000000000000000	   0.10000000000000001	    4.0000000000000000		]; 
